function Dialogue(interior, x, y, direction) {
	var dir = typeof direction !== 'undefined' ? direction : "left"; // left or right

	this.x = x;
	this.y = y;
	this.interior = interior;
	this.direction = dir;
	this.workerAlias = null;
	this._hold = false;
	this._gotoRoot = false;

	var p = interior.bitmap.localToGlobal(x, y);

	$("#dialogue").css({
		left: p.x,
		top: p.y,
		width: "350px",
		/*300*/
		height: "550px",
		/*450*/
		backgroundColor: "background-color:rgba(255,255,255,0.7)",
		display: "none"
	});

	if (this.x != undefined)
		$("#dialogue").attr("canvasX", p.x);
	if (this.y != undefined)
		$("#dialogue").attr("canvasY", p.y);
	this.x = p.x;
	this.y = p.y;
};

Dialogue.current = null;

Dialogue.prototype.setWorkerAlias = function(alias) {
	this.workerAlias = alias;
}

Dialogue.prototype.continueDialog = function() {
	this._hold = false;
}

Dialogue.prototype.gotoRoot = function() {
	if (this._hold) {
		this._gotoRoot = true;
		this._hold = false;
	} else {
		this._gotoRoot = false;
		var root = $('#conversationStatements [hash="' + this.interior.name + '"]');
		this.officialStatement(root.attr("dialogueId"));
	}
}

Dialogue.prototype.isStopped = function() {
	return this._hold;
}

Dialogue.prototype.enable = function() {
	//ustaw current dialog
	Dialogue.current = this;
	this._hold = false;

	var dia = this;
	var INTERIOR = this.interior;
	$.get(window.links.studentAjaxGetDialogue, {
			hash: INTERIOR.name
		})
		.done(function(data) {
			$("#dialogue").css({
				left: dia.x,
				top: dia.y,
			});

			if (dia.x != undefined)
				$("#dialogue").attr("canvasX", dia.x);
			if (dia.y != undefined)
				$("#dialogue").attr("canvasY", dia.y);

			if (dia.direction == "right") {
				$("#dialogue").removeClass("dialogue-arrow-left");
				$("#dialogue").addClass("dialogue-arrow-right");
			} else // if left or error
			{
				$("#dialogue").removeClass("dialogue-arrow-right");
				$("#dialogue").addClass("dialogue-arrow-left");
			}
			// ---------------------------------------------

			var conversation = jQuery.parseJSON(data);

			$("#conversationStatements").html("");
			$("#chat").html("");
			$("#questions").html("");

			for (var i = 0; i < conversation.length; i++) {
				var conversationDiv = $('<div></div>');
				conversationDiv.attr("dialogueId", conversation[i].id);
				conversationDiv.attr("dialogueParentId", conversation[i].idRodzica);
				conversationDiv.attr("userStatement", conversation[i].wypowiedzGracza);
				conversationDiv.attr("officialStatement", conversation[i].wypowiedzUrzednika);
				conversationDiv.attr("hash", conversation[i].hash);
				conversationDiv.attr("action", conversation[i].akcja);
				conversationDiv.attr("jumpTo", conversation[i].skoczDoWypowiedziZId);
				conversationDiv.attr("condition", conversation[i].condition);
				if (conversation[i].condition === null)
					$("#conversationStatements").append(conversationDiv);
				else {
					var result = $(document).triggerHandler(conversation[i].condition + '.przedsiebiorcaDialogueEvents');
					//	console.log(conversation[i].condition+" : "+result);
					if (result === undefined) {
						// if current action has allowedInterior == conversation[i].condition then don't show that answer
						//if(conversation[i].condition in window.userdata.allowedInteriors)

						if (typeof window.userdata.allowedInteriors[conversation[i].condition] !== 'undefined')
							result = false; // return false;
						else
							result = true; // return true;

						/* INFO ***
							console.warn('dialog #' + conversation[i].id + ' (' + INTERIOR.name
							+ ') condition handler ' + conversation[i].condition + '.przedsiebiorcaDialogueEvents returned null '
							+ '(missing return statement, handler not attached, handler returned undefined value)');
						** INFO **/
					}

					// else
					if (result) {
						$('#conversationStatements').append(conversationDiv);
					} else {
						// do not append this answer
						//conversationDiv.remove();
						//conversationDiv.append("<del>"+conversationDiv+"</del>");
					}
				}
			}
			$("#dialogue").fadeIn();
			dia.officialStatement();
		});
}

String.prototype.c = function() {
	return this.replace(/\[(.*?)\/(.*?)\]/g, window.userdata['plec'] == 'm' ? '$1' : '$2');
};

Dialogue.strc = function(str) {
	if (typeof str === 'string' || str instanceof String)
		return str.c();
	else
		return '';
}

//function officialStatement(questionId)
Dialogue.prototype.officialStatement = function(questionId) {
	var INTERIOR = this.interior;

	function processMessage(message) {
		var match = message.match(/\{([^\}]{1,})\}/gi);
		for (var i in match) {
			var x = match[i];
			var key = x.substring(1, x.length - 1);
			var result = $(document).triggerHandler('getDialogueParam.przedsiebiorcaDialogueEvents', key);
			if (result !== undefined)
				message = message.replace(x, result);
			else
				console.warn('parametrer handler in dialog (' + INTERIOR.name + ') - getDialogueParam.' + 'przedsiebiorcaDialogueEvents(' + key + ') returned null ' + '(missing return statement, handler not attached, handler returned undefined value)');
		}
		return message;
	}

	if ($("#chat").children().length == 0) {
		// podmiana plci
		//var str = root.attr("officialStatement");
		var str = $("#conversationStatements").html();
		str = Dialogue.strc(str);
		$("#conversationStatements").html(str);

		//getting root
		//var root = $('#conversationStatements [hash="urzadPracy_urzednik2"]');
		//var root = $('#conversationStatements [hash="urzadPracy_rozmowa2"]');
		//var root = $('#conversationStatements [hash="intUPr2"]');
		var root = $('#conversationStatements [hash="' + this.interior.name + '"]');
		var workerAlias = this.workerAlias;
		if (workerAlias === undefined || workerAlias === null)
			workerAlias = 'Pracownik';
		$("#chat").append("<p><b>" + workerAlias + ":</b> <span></span></p>");
		$("#chat p:last span").uniqueId();

		var text = processMessage(root.attr("officialStatement"));
		$("#chat p:last span").writeText(text, showQuestions);

		$("#questions").css("display", "none");

		$("#questions").html("<ul></ul>");

		$('#conversationStatements [dialogueParentId="' + root.attr("dialogueId") + '"]').each(function() {
			var userText = processMessage($(this).attr("userStatement"));
			$("#questions ul").append('<li><span class="question" dialogueId="' + $(this).attr("dialogueId") + '" >' + userText + '</span></li>');
		});
	} else {
		var node = $('#conversationStatements [dialogueId="' + questionId + '"]');

		//handle actions first
		var actionHash = node.attr("action");
		if (actionHash !== undefined && actionHash.length) {
			if (actionHash.indexOf('js:') === 0) {
				//action is javascript event handler name
				var eventHandlerName = actionHash.substring(3);
				$(document).trigger(eventHandlerName + '.przedsiebiorcaDialogueEvents');
			} else if (actionHash.indexOf('js(hold):') === 0) {
				var eventHandlerName = actionHash.substring(9);
				$(document).trigger(eventHandlerName + '.przedsiebiorcaDialogueEvents');
				this._hold = true;
			} else {
				//action in hash
				window.location.hash = actionHash;
				return;
			}
		}

		$("#questions").css("display", "none");
		$("#questions").html("<ul></ul>");
		/*
		$('#chat').animate({
			scrollTop: $("#chat p:last").offset().top
		}, 2000);
		*/

		var DLG = this;

		function say() {
			if (DLG._hold) {
				setTimeout(say, 0);
				return;
			}

			if (node.attr("jumpTo") != undefined && node.attr("jumpTo").length) {
				DLG.officialStatement(node.attr("jumpTo"));
				return;
			}

			if (DLG._gotoRoot) {
				DLG._gotoRoot = false;
				var root = $('#conversationStatements [hash="' + DLG.interior.name + '"]');
				DLG.officialStatement(root.attr("dialogueId"));
				return;
			}

			if (node.attr("officialStatement") != undefined) {
				var text = processMessage(node.attr("officialStatement"));
				var workerAlias = DLG.workerAlias;
				if (workerAlias === undefined || workerAlias === null)
					workerAlias = 'Pracownik';
				$("#chat").append("<p><b>" + workerAlias + ":</b> <span></span></p>");
				$("#chat p:last span").uniqueId();
				$("#chat p:last span").writeText(text, showQuestions, scrollToLastCharacter);
			} else {
				showQuestions();
			}

			$('#conversationStatements [dialogueParentId="' + node.attr("dialogueId") + '"]').each(function() {
				var userText = processMessage($(this).attr("userStatement"));
				$("#questions ul").append('<li><span class="question" dialogueId="' + $(this).attr("dialogueId") + '" >' + userText + '</span></li>');
			});
		}
		if (DLG._hold)
			setTimeout(say, 0);
		else
			say();
	}
}

window.prevCharPosition = 0;

function scrollToLastCharacter() {
	$('#chat').animate({
		scrollTop: $('#chat')[0].scrollHeight
	}, 2000);
}

function showQuestions() {
	$('#chat').clearQueue().finish();
	$("#questions").fadeIn();
	$('#chat').animate({
		scrollTop: $('#chat')[0].scrollHeight
	}, 2000);
}

$(document).on("click", "#questions span", function(event) {
	if (!Dialogue.current.isStopped()) {
		$("#chat").append('<p><b>Ja:</b> ' + $(this).text() + '</p>');
		Dialogue.current.officialStatement($(this).attr("dialogueId"));
	}
});

$(document).on('wniosek.przedsiebiorcaDialogueEvents', function() {

	if (window.userdata["tura"] == "3") {
		// sprawdz czy dotacja zaakceptowana
		function checkForm(handler) {
			$.get(window.links.studentAjaxGetUserData, {
				"formid": "1"
			}, function(re) {
				handler(re);
			});
		}

		checkForm(function(output) {
			return output;
		});
	} else return;
});

$(document).on('konto.przedsiebiorcaDialogueEvents', function() {
	if (window.userdata["tura"] == "4" && window.userdata["tura_aktywna"] && (!window.userdata["stan_konta"] || window.userdata["stan_konta"] <= 0)) {
		$.get(window.links.studentAjaxGetCompanyBank, function(res) {
			if (res >= 1 && res <= 4) {
				return true;
			}
		});

	}
	return false;
});
